﻿using System;
using System.Collections.Generic;
using System.Text;
using gov.va.med.VBECS.Communication.Common;
using gov.va.med.VBECS.Communication.Utils;

namespace gov.va.med.VBECS.Communication.Protocols
{
    public class RawDataProtocol : IProtocol
    {
        #if TRACE
            IMessageSerializer _sr = new TextMessageSerializer();
        #endif

        public byte[] GetBytes(IMessage theMsg)
        {
            byte[] msgBytes = null;

            if (theMsg is RawDataMessage)
            {
                msgBytes = ((RawDataMessage)theMsg).Data;
            }
            else
            {
                msgBytes = Encoding.UTF8.GetBytes(theMsg.ToString());
            }

            #if TRACE
                _sr.SerializeObject("Messages\\Responce_RawProtocol_" + Guid.NewGuid().ToString(), new RawDataMessage(msgBytes));
            #endif

            return msgBytes;
        }

        public IEnumerable<IMessage> BuildMessages(byte[] theBytes)
        {
            #if TRACE
                _sr.SerializeObject("Messages\\Reply_RawProtocol_" + Guid.NewGuid().ToString(), new RawDataMessage(theBytes));
            #endif

            return new IMessage[] { new RawDataMessage { Data = theBytes } };
        }

        public void Reset()
        {

        }
    }
}
